/*
 * This source file is part of libRocket, the HTML/CSS Interface Middleware
 *
 * For the latest information, see http://www.librocket.com
 *
 * Copyright (c) 2008-2010 CodePoint Ltd, Shift Technology Ltd
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 */

#include "../../Include/Rocket/Debugger/Debugger.h"
#include "../../Include/Rocket/Core.h"
#include "Plugin.h"

namespace Rocket {
namespace Debugger {

// Initialises the debug plugin. The debugger will be loaded into the given context.
bool Initialise(Core::Context* context)
{
	if (Plugin::GetInstance() != NULL)
	{
		Core::Log::Message(Core::Log::LT_WARNING, "Unable to initialise debugger plugin, already initialised!");
		return false;
	}

	Plugin* plugin = new Plugin();
	if (!plugin->Initialise(context))
	{
		Core::Log::Message(Core::Log::LT_WARNING, "Unable to initialise debugger plugin.");

		delete plugin;
		return false;
	}

	SetContext(context);
	Core::RegisterPlugin(plugin);

	return true;
}

// Sets the context to be debugged.
bool SetContext(Core::Context* context)
{
	Plugin* plugin = Plugin::GetInstance();
	if (plugin == NULL)
		return false;

	plugin->SetContext(context);

	return true;
}

// Sets the visibility of the debugger.
void SetVisible(bool visibility)
{
	Plugin* plugin = Plugin::GetInstance();
	if (plugin != NULL)
		plugin->SetVisible(visibility);
}

// Returns the visibility of the debugger.
bool IsVisible()
{
	Plugin* plugin = Plugin::GetInstance();
	if (plugin == NULL)
		return false;

	return plugin->IsVisible();
}

}
}
