# @file    TestSyntaxChecker.rb
# @brief   SyntaxChecker unit tests
#
# @author  Akiya Jouraku (Ruby conversion)
# @author  Sarah Keating 
#
#
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestSyntaxChecker.c
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------
require 'test/unit'
require 'libSBML'

class TestSyntaxChecker < Test::Unit::TestCase

  def test_SyntaxChecker_validID
    assert( LibSBML::SyntaxChecker.isValidXMLID("cell") == true )
    assert( LibSBML::SyntaxChecker.isValidXMLID("1cell") == false )
    assert( LibSBML::SyntaxChecker.isValidXMLID("_cell") == true )
  end

  def test_SyntaxChecker_validId
    assert( LibSBML::SyntaxChecker.isValidSBMLSId("cell") == true )
    assert( LibSBML::SyntaxChecker.isValidSBMLSId("1cell") == false )
    assert( LibSBML::SyntaxChecker.isValidSBMLSId("") == false )
  end

  def test_SyntaxChecker_validUnitId
    assert( LibSBML::SyntaxChecker.isValidUnitSId("cell") == true )
    assert( LibSBML::SyntaxChecker.isValidUnitSId("1cell") == false )
  end

  def test_SyntaxChecker_validXHTML
    ns24 = LibSBML::SBMLNamespaces.new(2,4)
    ns31 = LibSBML::SBMLNamespaces.new(3,1)
    toptriple = LibSBML::XMLTriple.new("notes", "", "")
    triple = LibSBML::XMLTriple.new("p", "", "")
    att = LibSBML::XMLAttributes.new()
    ns = LibSBML::XMLNamespaces.new()
    ns.add( "http://www.w3.org/1999/xhtml", "")
    tt = LibSBML::XMLToken.new("This is my text")
    n1 = LibSBML::XMLNode.new(tt)
    toptoken = LibSBML::XMLToken.new(toptriple,att)
    topnode = LibSBML::XMLNode.new(toptoken)
    token = LibSBML::XMLToken.new(triple,att,ns)
    node = LibSBML::XMLNode.new(token)
    node.addChild(n1)
    topnode.addChild(node)
    assert( LibSBML::SyntaxChecker.hasExpectedXHTMLSyntax(topnode,nil) == true )
    assert( LibSBML::SyntaxChecker.hasExpectedXHTMLSyntax(topnode,ns24) == true )
    assert( LibSBML::SyntaxChecker.hasExpectedXHTMLSyntax(topnode,ns31) == true )
    triple = LibSBML::XMLTriple.new("html", "", "")
    token = LibSBML::XMLToken.new(triple,att,ns)
    node = LibSBML::XMLNode.new(token)
    node.addChild(n1)
    topnode.removeChild(0)
    topnode.addChild(node)
    assert( LibSBML::SyntaxChecker.hasExpectedXHTMLSyntax(topnode,nil) == true )
    assert( LibSBML::SyntaxChecker.hasExpectedXHTMLSyntax(topnode,ns24) == false )
    assert( LibSBML::SyntaxChecker.hasExpectedXHTMLSyntax(topnode,ns31) == true )
    triple = LibSBML::XMLTriple.new("html", "", "")
    ns.clear()
    token = LibSBML::XMLToken.new(triple,att,ns)
    node = LibSBML::XMLNode.new(token)
    node.addChild(n1)
    topnode.removeChild(0)
    topnode.addChild(node)
    assert( LibSBML::SyntaxChecker.hasExpectedXHTMLSyntax(topnode,nil) == false )
    assert( LibSBML::SyntaxChecker.hasExpectedXHTMLSyntax(topnode,ns24) == false )
    assert( LibSBML::SyntaxChecker.hasExpectedXHTMLSyntax(topnode,ns31) == false )
  end

end

