# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class CompositionMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of CompositionMode."""

    RETURN_LONGEST_OVERLAP = "returnLongestOverlap"
    """When two or more components are found in the text and overlap, the component with the longest
    set of characters is returned."""
    REQUIRE_EXACT_OVERLAP = "requireExactOverlap"
    """All components must overlap at the exact same characters in the text for the entity to return.
    If one of the defined components is not matched or predicted, the entity will not return."""
    SEPARATE_COMPONENTS = "separateComponents"
    """Every component's match or prediction is returned as a separate instance of the entity."""
    COMBINE_COMPONENTS = "combineComponents"
    """When two or more components are found in the text and overlap, the components' spans are merged
    together into one span combining all of them."""


class DataGenerationConnectionKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Represents the connection kind for Azure OpenAI deployment."""

    AZURE_OPEN_AI = "AzureOpenAI"


class DatasetType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The dataset for this utterance. Allowed values are 'Train' and 'Test'."""

    TRAIN = "Train"
    """Split the data into training and test sets according to user-defined percentages."""
    TEST = "Test"
    """Split the data according to the chosen dataset for every example in the data."""


class EvaluationKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of EvaluationKind."""

    PERCENTAGE = "percentage"
    """Split the data into training and test sets according to user-defined percentages."""
    MANUAL = "manual"
    """Split the data according to the chosen dataset for every example in the data."""


class ExportedProjectFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of ExportedProjectFormat."""

    CONVERSATION = "Conversation"
    """Specifies the format for a conversational project."""
    LUIS = "Luis"
    """Specifies the format for an application that was exported from LUIS."""


class OperationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of OperationStatus."""

    NOT_STARTED = "notStarted"
    RUNNING = "running"
    SUCCEEDED = "succeeded"
    FAILED = "failed"
    CANCELLED = "cancelled"
    CANCELLING = "cancelling"
    PARTIALLY_COMPLETED = "partiallyCompleted"


class OrchestrationTargetProjectKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of OrchestrationTargetProjectKind."""

    LUIS = "Luis"
    CONVERSATION = "Conversation"
    QUESTION_ANSWERING = "QuestionAnswering"


class ProjectKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of ProjectKind."""

    CONVERSATION = "Conversation"
    """A project to build natural language into apps, bots, and IoT devices."""
    ORCHESTRATION = "Orchestration"
    """A project to connect and orchestrate Conversation, Custom question answering and LUIS projects
    together in one single project."""
    CUSTOM_CONVERSATION_SUMMARIZATION = "CustomConversationSummarization"
    """A project to build conversation summarization models which are able to summarize long
    conversations."""


class StringIndexType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of StringIndexType."""

    UTF16_CODE_UNIT = "Utf16CodeUnit"
    """The offset and length values will correspond to UTF-16 code units. Use this option if your
    application is written in a language that support Unicode, for example Java, JavaScript."""
    UTF8_CODE_UNIT = "Utf8CodeUnit"
    UTF32_CODE_UNIT = "Utf32CodeUnit"


class TrainingMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of TrainingMode."""

    ADVANCED = "advanced"
    """Trains using fine-tuned neural network transformer models. Can train multilingual projects."""
    STANDARD = "standard"
    """Faster training times for quicker iterations."""
